/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import cc.tweaked_programs.cccbridge.blockEntity.RedRouterBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedRouterBlockPeripheral
implements IPeripheral {
    private final RedRouterBlockEntity redrouter_be;

    public RedRouterBlockPeripheral(RedRouterBlockEntity redrouter_block_entity) {
        this.redrouter_be = redrouter_block_entity;
    }

    @NotNull
    public String getType() {
        return "redrouter";
    }

    public Direction getActualSide(ComputerSide side) {
        Direction facing = this.redrouter_be.getFacing();
        return switch (side.getName()) {
            case "front" -> facing.m_122424_();
            case "back" -> facing;
            case "left" -> facing.m_122427_();
            case "right" -> facing.m_122428_();
            case "top" -> Direction.DOWN;
            case "bottom" -> Direction.UP;
            default -> Direction.NORTH;
        };
    }

    @LuaFunction
    public final void setOutput(ComputerSide side, boolean on) {
        this.redrouter_be.setPower(this.getActualSide(side).m_122433_(), on ? 15 : 0);
    }

    @LuaFunction
    public final boolean getOutput(ComputerSide side) {
        return this.redrouter_be.getPower(this.getActualSide(side)) > 0;
    }

    @LuaFunction
    public final boolean getInput(ComputerSide side) {
        return this.redrouter_be.getRedstoneInput(this.getActualSide(side)) > 0;
    }

    @LuaFunction(value={"setAnalogOutput", "setAnalogueOutput"})
    public final void setAnalogOutput(ComputerSide side, int value) throws LuaException {
        if (value < 0 || value > 15) {
            throw new LuaException("Expected number in range 0-15");
        }
        this.redrouter_be.setPower(this.getActualSide(side).m_122433_(), value);
    }

    @LuaFunction(value={"getAnalogOutput", "getAnalogueOutput"})
    public final int getAnalogOutput(ComputerSide side) {
        return this.redrouter_be.getPower(this.getActualSide(side));
    }

    @LuaFunction(value={"getAnalogInput", "getAnalogueInput"})
    public final int getAnalogInput(ComputerSide side) {
        return this.redrouter_be.getRedstoneInput(this.getActualSide(side));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof RedRouterBlockPeripheral)) return false;
        RedRouterBlockPeripheral redrouter = (RedRouterBlockPeripheral)other;
        if (redrouter.redrouter_be != this.redrouter_be) return false;
        return true;
    }
}

